# Part of Odoo. See LICENSE file for full copyright and licensing details.

from odoo.fields import Domain

from odoo.addons.portal.controllers.thread import PortalThreadController


class PortalRatingThreadController(PortalThreadController):
    def _get_non_empty_message_domain(self):
        return super()._get_non_empty_message_domain() | Domain("rating_value", "!=", False)

    def _setup_portal_message_fetch_extra_domain(self, data):
        domain = super()._setup_portal_message_fetch_extra_domain(data)
        if data.get('rating_value', False) is not False:
            domain &= Domain('rating_value', '=', float(data['rating_value']))
        return domain
