from odoo.addons.point_of_sale.tests.test_frontend import TestPointOfSaleHttpCommon
from odoo.tests import tagged
from odoo.fields import Command


@tagged('post_install', '-at_install', 'post_install_l10n')
class TestGenericLocalization(TestPointOfSaleHttpCommon):
    allow_inherited_tests_method = True

    @classmethod
    def setUpClass(cls):
        super().setUpClass()
        cls.partner_a.name = "AAAA Generic Partner"
        cls.partner_a.vat = "32345678"
        cls.whiteboard_pen.write({
            'standard_price': 10.0,
            'taxes_id': [Command.link(cls.tax_sale_a.id)]
        })

        cls.wall_shelf.write({
            'standard_price': 10.0,
            'taxes_id': [Command.link(cls.tax_sale_a.id)]
        })

    def test_generic_localization(self):
        self.main_pos_config.open_ui()
        url = "/pos/ui?config_id=%d" % self.main_pos_config.id
        url += "&company_name=%s" % self.main_pos_config.company_id.name
        self.start_tour(url, "generic_localization_tour", login="accountman")
        last_order = self.main_pos_config.current_session_id.order_ids[-1]
        html_data = last_order.order_receipt_generate_html()
        last_order.order_receipt_generate_image()  # verify if image generation works
        return last_order, html_data
